%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function mesh = readmesh2(filebase);

% Filenames

type1 = 'node';
type2 = 'ele';

% Read in nodes
file = sprintf('%s.%s',filebase,type1);
[num_nodes,attr] = textread(file,'%d %*d %d %*d',1);
nodes = zeros(num_nodes,2);
if (attr==0)
  [nodes(:,1), nodes(:,2) boundary] = textread(file,'%*d %f %f %d',...
     num_nodes,'headerlines',1);
elseif (attr==1)
  [nodes(:,1), nodes(:,2) boundary] = textread(file,'%*d %f %f %*d %d',...
     num_nodes,'headerlines',1);
end;

% Read in element connectivity
file = sprintf('%s.%s',filebase,type2);
[num_ele] = textread(file,'%d %*d %*d',1);
ele = zeros(num_ele,3);
[ele(:,1), ele(:,2), ele(:,3)] = textread(file,'%*d %d %d %d',...
   num_ele,'headerlines',1);

%%%%%%%%%%%%%
% comment it for suzanne
% for hydrocephalus..need to comment it
ele=ele+1;

%%%%%%%%%%%%%
mesh = struct('coords',nodes,'tris',ele,'border',boundary);
